rs = function () {
    return "try rs.help()";
};

rs.add = function (host, arbiterOnly) {
    if (arbiterOnly == true && !isString(host))
        nav_throwError("Applies only if the <host> value is a string");

    var replsetInfo = db.getSiblingDB("local").system.replset.findOne();
    if (replsetInfo == null)
        nav_throwError("Failed to retrieve replica set config");
    replsetInfo.version++;

    var replSetReconfig = host;
    var maxID = 0;
    for (var i in replsetInfo.members)
        if (replsetInfo.members[i]._id > maxID)
            maxID = replsetInfo.members[i]._id;
    if (isString(host)) {
        replSetReconfig = {};
        replSetReconfig._id = maxID + 1;
        replSetReconfig.host = host;
        if (arbiterOnly)
            replSetReconfig.arbiterOnly = true;
    }
    if (replSetReconfig._id == null)
        replSetReconfig._id = maxID + 1;
    replsetInfo.members.push(replSetReconfig);
    return db.adminCommand({ replSetReconfig: replsetInfo });
};

rs.addArb = function (host) {
    return this.add(host, true);
};

rs.conf = function () {
    var result = db.adminCommand({ replSetGetConfig: 1 });
    if (result.ok && !(result.errmsg) && result.config)
        return result.config;
    else if (result.errmsg && result.errmsg.startsWith("no such cmd"))
        return db.getSiblingDB("local").system.replset.findOne();
    nav_throwError("Failed to retrieve replica set config: " + tojson(result));
};
rs.config = rs.conf;

rs.freeze = function (seconds) {
    return db.adminCommand({ replSetFreeze: seconds });
};

rs.help = function () {
    print(
    "\trs.status()                                      { replSetGetStatus : 1 } checks repl set status\n" +
    "\trs.initiate()                                    { replSetInitiate : null } initiates set with default settings\n" +
    "\trs.initiate(cfg)                                 { replSetInitiate : cfg } initiates set with configuration cfg\n" +
    "\trs.conf()                                        get the current configuration object from local.system.replset\n" +
    "\trs.reconfig(cfg)                                 updates the configuration of a running replica set with cfg (disconnects)\n" +
    "\trs.reconfigForPSASet(memberIndex, cfg, opts)     updates the configuration of a Primary-Secondary-Arbiter (PSA) replica set while preserving majority writes\n" +
    "\trs.add(hostportstr)                              add a new member to the set with default attributes (disconnects)\n" +
    "\trs.add(membercfgobj)                             add a new member to the set with extra attributes (disconnects)\n" +
    "\trs.addArb(hostportstr)                           add a new member which is arbiterOnly:true (disconnects)\n" +
    "\trs.stepDown([stepdownSecs, catchUpSecs])         step down as primary (disconnects)\n" +
    "\trs.syncFrom(hostportstr)                         make a secondary sync from the given member\n" +
    "\trs.freeze(secs)                                  make a node ineligible to become primary for the time specified\n" +
    "\trs.remove(hostportstr)                           remove a host from the replica set (disconnects)\n" +
    "\trs.slaveOk()                                     allow queries on secondary nodes\n" +
    "\n" +
    "\trs.printReplicationInfo()                        check oplog size and time range\n" +
    "\trs.printSlaveReplicationInfo()                   check replica set members and replication lag\n" +
    "\trs.printSecondaryReplicationInfo()               check replica set members and replication lag\n" +
    "\tdb.isMaster()                                    check who is primary\n" +
    "\tdb.hello()                                       check who is primary\n" +
    "\n" +
    "\treconfiguration helpers disconnect from the database so the shell will display\n" +
    "\tan error, even if the command succeeds.\n");
};

rs.initiate = function (configuration) {
    return db.adminCommand({ replSetInitiate: configuration });
};

rs.printReplicationInfo = function () {
    return db.printReplicationInfo();
};

rs.printSlaveReplicationInfo = function () {
    return db.printSlaveReplicationInfo();
};
rs.printSecondaryReplicationInfo = rs.printSlaveReplicationInfo;

rs.reconfig = function (configuration, force) {
    configuration.version = rs.conf().version + 1;
    command = { replSetReconfig: configuration };
    for (var prop in force)
        command[prop] = force[prop];
    return db.adminCommand(command);
};

_validateMemberIndex = function (memberIndex, newConfig) {
    var newMemberConfig = newConfig.members[memberIndex];
    if (isUndefined(newMemberConfig))
        nav_throwError(`member at index ${memberIndex} does not exist in the new config`);

    if (newMemberConfig.votes != 1)
        nav_throwError(`member at index ${memberIndex} must have {votes: 1} in the new config`);
        
    var memberId = newMemberConfig._id;
    var oldConfig = rs.conf();
    var oldMemberConfig = oldConfig.members.find(member => member._id === memberId);
    
    if (!oldMemberConfig)
        return;

    if (oldMemberConfig.votes)
        nav_throwError(`member at index ${memberIndex} must have {votes: 0} in the old config`);
};

rs.reconfigForPSASet = function (memberIndex, config, options) {
    _validateMemberIndex(memberIndex, config);

    var memberPriority = config.members[memberIndex].priority;
    config.members[memberIndex].votes = 1;
    config.members[memberIndex].priority = 0;
    var result = rs.reconfig(config, options);
    if (!result.ok) {
        return result;
    }
    
    config.members[memberIndex].priority = memberPriority;
    
    return rs.reconfig(config, options);
};

rs.remove = function (hostname) {
    var replsetInfo = db.getSiblingDB("local").system.replset.findOne();
    if (replsetInfo == null)
        nav_throwError("Failed to retrieve replica set config");
    replsetInfo.version++;

    for (var i in replsetInfo.members) {
        if (replsetInfo.members[i].host == hostname) {
            replsetInfo.members.splice(i, 1);
            return db.adminCommand({ replSetReconfig: replsetInfo });
        }
    }

    return "Error: couldn't find " + hostname + " in " + tojson(replsetInfo.members);
};

rs.slaveOk = function (value) {
    db.getMongo().setSlaveOk(value);
};

rs.status = function () {
    return db.adminCommand({ replSetGetStatus: 1 });
};

rs.stepDown = function (stepDownSecs, secondaryCatchUpPeriodSecs) {
    var command = { replSetStepDown: stepDownSecs === undefined ? 60 : stepDownSecs };
    if (secondaryCatchUpPeriodSecs !== undefined) {
        command['secondaryCatchUpPeriodSecs'] = secondaryCatchUpPeriodSecs;
    }
    return db.adminCommand(command);
};

rs.syncFrom = function (host) {
    return db.adminCommand({ replSetSyncFrom: host });
};

rs.isMaster = function () {
    return db.isMaster();
};